% Model of a nonisothermal non-steady state CSTR

% Function file

% For more information, see:

% A. De Visscher 
% Lecture Notes in Chemical Engineering Kinetics and Chemical Reactor Design
% Createspace (2013) 

% (C) Alex De Visscher (2013)

% ---------------------------

function dcdt = f(t,c,cA0,cB0,cC0,A,EA,V,Q,Tin,DH,CpA,CpB,CpC)

dcdt = zeros(4,1);     % Allocate space for the right-hand sides of the DEs

cA = c(1);                  % Concentration of A
cB = c(2);                  % Concentration of B
cC = c(3);                  % Concentration of C
T = c(4);                   % Temperature

R = 8.314472;
k = A*exp(-EA/(R*T));       % Rate constants
r = k*cA*cB;                % Reaction rate
rA = -r;
rB = -r;
rC = r;

Cpsum = V*(cA*CpA + cB*CpB + cC*CpC);

dcdt(1) = Q*(cA0 - cA)/V + rA;  % Differential equations for concentration
dcdt(2) = Q*(cB0 - cB)/V + rB;
dcdt(3) = Q*(cC0 - cC)/V + rC;
dcdt(4) = (-Q*(T - Tin)*(cA0*CpA + cB0*CpB + cC0*CpC) - V*r*DH)/Cpsum;
